
//--------------------------------------------------------------------------
// Weapon Damage Balance
// 
// This object determines the game balance of the deviation to weapon
// damage as caused by the attacker's weapon.  Each weapon has a
// "weapon_rating" key in its GDB definition, which is an integer from
// 1 to 7.  For a weapon of rating X, the "begin_X" key specifies the
// level configuration whose "masterlevel" key defines the exact level
// at which this weapon is considered to be GOOD.  Likewise, "end_X"
// determines when the weapon is considered BAD.
// 
// Beat damage is multiplied by the attacker's weapon's damage
// multiplier, where the multplier is BALANCE_WEAPON_EFFECTIVENESS_GOOD%
// at "begin" and BALANCE_WEAPON_EFFECTIVENESS_BAD% at "end".  Damage is
// extrapolated beyond the good (begin) / bad (end) extremes, so a weapon
// can theoretically do MORE than its "good" damage (or LESS than its "bad"
// damage), if the current masterlevel is below its "begin" level (or
// above its "end" level).
// 
// Final weapon multipliers are clamped to BALANCE_WEAPON_EFFECTIVENESS_MIN
// and BALANCE_WEAPON_EFFECTIVENESS_MAX.
// 
// Each of these constants is defined in Noxgame/STATS_Balance.c.
//--------------------------------------------------------------------------
#mystech Weapon Damage Balance
{
	begin_1		string	"whacks"
	end_1		string	"chamber"

	begin_2		string	"votowne"
	end_2		string	"routubes1_second"

	begin_3		string	"routubes1_second"
	end_3		string	"kraptonmaze"

	begin_4		string	"kraptonmaze"
	end_4		string	"onegate"

	begin_5		string	"onegate"
	end_5		string	"fortress2"

	begin_6		string	"fortress2"
	end_6		string	"ultimate"

	begin_7		string	"ultimate"
	end_7		string	"supergod"
}


//--------------------------------------------------------------------------
// Mystech Damage Balance
// 
// This object determines the game balance of mystech / elementor damage.
// 
// There are eight keys, one for each "effect level" that mystech can
// theoretically produce.  A mystech device outputting exactly enough,
// er, output to achive said "damage_X" will do exactly enough damage
// to kill (outright) a monster of the level specified in each named
// level configuration (in its "masterlevel" key).
// 
// damage_X		string	"<level configuration name>"
//--------------------------------------------------------------------------
#mystech Mystech Damage Balance
{
	damage_1	string	"fireslag_level"
	damage_2	string	"routubes1_second"
	damage_3	string	"krapton"
	damage_4	string	"firestorm_level"
	damage_5	string	"harmonic_level"
	damage_6	string	"ultimate"
	damage_7	string	"supergod"
	damage_8	string	"BOB"
}


//--------------------------------------------------------------------------
// Mystech Effect Energy Levels
// 
// This object determines the game balance of mystech / elementor energy-
// to-output-to-script-level.
// 
// There are eight keys, one for each "effect level" that mystech can
// theoretically produce.  A mystech device doing at least <output> (in
// the right column) will be considered to have an "effect level" of X,
// designated by the keyName (left column).
// 
// output_X		int		<output>
//--------------------------------------------------------------------------
#mystech Mystech Effect Energy Levels
{
	output_1	int		2
	output_2	int		32
	output_3	int		512
	output_4	int		1296
	output_5	int		1872
	output_6	int		2656
	output_7	int		10000
	output_8	int		100000
}



//--------------------------------------------------------------------------
// LEVEL CONFIGURATIONS
// 
// Each of the following "#level" entries is a GDB object that describes
// a "level configuration".  Each configuration has the following fields:
// 
// masterlevel		The global experience level around which game balance
//					is centered at the start of this level.  Monsters that
//					appear in battles while this configuration is active
//					are automatically assigned a level equal to the
//					current masterlevel, possibly modified up or down by
//					the "level_adjust" field in the monster's GDB
//					definition.  It also represents the level at which
//					most party members are expected to be at this point
//					in the game.
// 
// xp_levels		The number of experience levels the party is expected
//					to gain throughout the course of this level.  This is
//					assuming that the player does all required battles &
//					quests but not does assume optional ones (these are
//					above and beyond the base-expected XP of the party).
// 
//					The total experience awarded for a level is equal
//					to the difference in XP requirements between levels
//					(masterlevel) and (masterlevel + xp_levels).
// 
// xp_battles		Must be between 0.0 and 1.0; this determines the
//					percentage of total XP in this level that comes from
//					battles (as opposed to quests).  A value of 0.0 means
//					that ALL XP comes from quests - monsters give NO XP.
//					A value of 1.0 means that ALL XP comes from monsters -
//					quests give NO XP.
// 
// quest_X			Each required quest is listed as a unique key entry.
//					The quest's GDB object is named.
// 
// monster_X		Each required monster type you fight is listed as a
//					unique key entry.  The monster's GDB object is named,
//					followed by a semicolon, followed by the number of
//					that monster which appear in the level.
// 
// NOTE: some levels may have more than one configuration.  This is
// useful in cases such as the Bricks where the area will undergo a
// change throughout the course of the game, and its monsters / quests
// / masterlevel / XP distribution will be different the second time
// around.
//--------------------------------------------------------------------------

#level fireslag_level
{
	masterlevel	float	8
	xp_levels	float	0
}

#level firestorm_level
{
	masterlevel	float	35
	xp_levels	float	0
}

#level harmonic_level
{
	masterlevel	float	40
	xp_levels	float	0
}


#level BOB
{
	masterlevel	int		99
	xp_levels	float	0
}

// Introduction 

#level rowdys
{
	masterlevel	float	1
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Fatima Stop"
	quest_2		string	"Get Your Camera"
	quest_3		string	"Get Some Money"
	quest_4		string	"Use Time Minder"
	quest_5		string	"Talk To Valesta"
}

#level whacks
{
	masterlevel	float	1
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Go To Whackmaster"
}

#level bricksd
{
	masterlevel	float	2
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Ppaki; 1"
}


#level bricksb
{
	masterlevel	float	2
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Gorian Drug Runner; 1"
	monster_2	string	"Unhappy Nox Grumbleguard; 1"
}


#level bricksc2
{
	masterlevel	float	2
	xp_levels	float	.1
	xp_battles	float	1
	monster_1	string	"Alley Goon; 2"
}


#level grumpos_first
{
	masterlevel	float	2
	xp_levels	float	.4
	xp_battles	float	0
	quest_1		string	"Find A Job"
	quest_2		string	"Find Matavastros"
	quest_3		string	"Get Hired By Grumpos"
	quest_4		string	"Get Stuff to Grumpos"
}

// reward for the follow lucko mini-game

#level tours
{
	masterlevel	float	3
	xp_levels	float	.2
	xp_battles	float	0	
	quest_1		string 	"Know Lucko"
}

#level hovel_first
{
	masterlevel	float	3.2
	xp_levels	float	2
	xp_battles	float	.9
	monster_1	string	"Alley Goon; 8"
	monster_2	string	"Gorite; 5"
	quest_1		string	"Find More Info on Eddie"
}

// MYSTECH_ACTIVE

#level hovel_second
{
	masterlevel	float	20
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Alley Goon; 10"
	monster_2	string	"Gorite; 6"
}

// PRE_DETTA

#level hovel_third
{
	masterlevel	float	30
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Alley Goon; 10"
	monster_2	string	"Gorite; 6"
}


// MET_DETTA == 0

#level mystech1_first
{
	masterlevel	float	5.2
	xp_levels	float	2
	xp_battles	float	1
	monster_1	string	"Cave Crawler; 2"
	monster_2	string	"skitter; 8"
	monster_3	string	"Mean Mole; 5"
	monster_4	string	"Stare Bear; 1"
}

// MET_DETTA

#level mystech1_second
{
	masterlevel	float	11
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Cave Crawler; 4"
	monster_2	string	"skitter; 11"
	monster_3	string	"Mean Mole; 6"
	monster_4	string	"Stare Bear; 1"
}

// MYSTECH_ACTIVE

#level mystech1_third
{
	masterlevel	float	20
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Cave Crawler; 4"
	monster_2	string	"skitter; 11"
	monster_3	string	"Mean Mole; 6"
	monster_4	string	"Stare Bear; 1"
}

// PRE_KRAPTON

#level mystech1_fourth
{
	masterlevel	float	25
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Cave Crawler; 4"
	monster_2	string	"skitter; 11"
	monster_3	string	"Mean Mole; 6"
	monster_4	string	"Stare Bear; 1"
}

// PRE_LIMBUS

#level mystech1_fifth
{
	masterlevel	float	30
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Cave Crawler; 4"
	monster_2	string	"skitter; 11"
	monster_3	string	"Mean Mole; 6"
	monster_4	string	"Stare Bear; 1"
}

// PRE_DETTA

#level mystech1_sixth
{
	masterlevel	float	32
	xp_levels	float	3
	xp_battles	float	1
	monster_1	string	"GEAS Nox Guard; 6"
	monster_2	string	"Robottack; 4"
	monster_3	string	"Anox Doorlord; 1"
}


// sewagic1a minigame

//#level sewagic1a
//{
//	masterlevel	float	7.2
//	xp_levels	float	.5
//	xp_battles	float	0
//	quest_1		string	"Sewagic Rapids"
//}


#level mystech2
{
	masterlevel	float	7.2
	xp_levels	float	3.8
	xp_battles	float	1
	monster_1	string	"Cave Crawler; 4"
	monster_2	string	"skitter; 6"
	monster_3	string	"Mean Mole; 4"
	monster_4	string	"Stare Bear; 7"
	monster_5	string	"Stone Sentinel; 1"
}

/*
#level bricksd
{
	masterlevel	float	11
	xp_levels	float	.25
	xp_battles	float	1
	monster_1	string	"Gorian Drug Runner; 4"
}
*/

// May wish to break this up eventually so player is rewarded on both sub-parts.

#level tours2
{
	masterlevel	float	11
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Get To Sender Station"
}

#level senderss
{
	masterlevel	float	11
	xp_levels	float	.2
	xp_battles	float	0
	quest_1		string	"Get Past Sunder Shuttle Door"
	quest_2		string	"Get On Sunder Shuttle Do Know"
}

// (MYSTECH_ACTIVE == 0)

#level routubes1_first
{
	masterlevel	float	11
	xp_levels	float	.25
	xp_battles	float	.6
	monster_1	string	"Mad Gorian; 1"
	monster_2	string	"Pipe Mimic; 4"
//	monster_3	"Gorian Drug Runner; 1"
	quest_1		string	"Get One Ticket To Sunder"
}

#level vendomart
{
	masterlevel	float	11
	xp_levels	float	.1
	xp_battles	float	0
	quest_1		string	"Look Like Scientists"
}

#level scommons
{
	masterlevel	float	11
	xp_levels	float	.2
	xp_battles	float	0
	quest_1		string	"Get Two Tickets To Sunder"
	quest_2		string	"Get One Ticket To Sunder"
}

#level sendormitory
{
	masterlevel	float	11
	xp_levels	float	.1
	xp_battles	float	0
	quest_1		string	"Get Two Tickets To Sunder"
}

#level starport
{
	masterlevel	float	12
	xp_levels	float	1
	xp_battles	float	0
	quest_1		string	"Disable Blue Laser"
	quest_2		string	"Disable Green Laser"
	quest_3		string	"Disable Red Laser"
	quest_4		string	"Get To Starport Gate"
}

#level cinedem
{
	masterlevel	float	13
	xp_levels	float	.15
	xp_battles	float	1
	monster_1	string	"Robode; 2"
	monster_2	string	"Damaged Robode; 1"
}

#level chamber
{
	masterlevel	float	13
	xp_levels	float	.15
	xp_battles	float	1
	monster_1	string	"Robode; 3"
}

#level votowne
{
	masterlevel	float	13
	xp_levels	float	.6125
	xp_battles	float	0
	quest_1		string	"What is Proposition 1 Vote"
	quest_2		string	"What is Proposition 2 Vote"
	quest_3		string	"What is Proposition 3 Vote"
	quest_4		string	"What is Proposition 5 Vote"
	quest_5		string	"What is Proposition 6 Vote"
	quest_6		string	"What is Proposition 7 Vote"
	quest_7		string	"What is Proposition 8 Vote"
}

#level republic
{
	masterlevel	float	13
	xp_levels	float	.0875
	xp_battles	float	0
	quest_1		string	"What is Proposition 4 Vote"
}


// This unnatural high quest XP award is to account for the assumed winning of hive game.

#level warshipbay_first
{
	masterlevel	float	14
	xp_levels	float	1
	xp_battles	float	.2
	monster_1	string	"Robode; 2"
	quest_1		string	"Get to Democratus Fighter"
}

// ELEMENTOR_ACTIVE

#level warshipbay_second
{
	masterlevel	float	30
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Robode; 10"
}


// Note:  severe possibility for level-pumping on this level because of repeatable battles.

#level hive
{
	masterlevel	float	15
	xp_levels	float	5
	xp_battles	float	1
	monster_1	string	"Verilent; 29"
	monster_2	string	"Hive Fighter; 5"
	monster_3	string	"Charmed Verilent; 1"
	monster_4	string	"Down Verilent; 1 "
	monster_5	string	"Up Verilent; 1"
	monster_6	string	"Bottom Verilent; 1"
	monster_7	string	"Strange Verilent; 1"
	monster_8	string	"Top Verilent; 1"
	monster_9	string	"Cybersect; 1"
	monster_10	string	"Hive Queen; 1"
	monster_11	string	"Smaller Hive Fighter; 2"
	monster_12	string	"Larger Hive Fighter; 1"
}

// (MYSTECH_ACTIVE == 1)

#level routubes1_second
{
	masterlevel	float	20
	xp_levels	float	.14
	xp_battles	float	1
	monster_1	string	"Mad Gorian; 1"
	monster_2	string	"Pipe Mimic; 4"
//	monster_3	"Gorian Drug Runner; 1"
}

// PRE_LIMBUS or PRE_DETTA

#level routubes1_third
{
	masterlevel	float	28
	xp_levels	float	.15
	xp_battles	float	1
	monster_1	string	"Mad Gorian; 1"
	monster_2	string	"Pipe Mimic; 4"
}


#level routubes2_first
{
	masterlevel	float	20
	xp_levels	float	.21
	xp_battles	float	1
	monster_1	string	"Gorian Drug Runner; 4"
	monster_2	string	"Mad Gorian; 2"
}

// PRE_LIMBUS or PRE_DETTA

#level routubes2_second
{
	masterlevel	float	28
	xp_levels	float	.25
	xp_battles	float	1
	monster_1	string	"Gorian Drug Runner; 4"
	monster_2	string	"Mad Gorian; 2"
}


// optional aside

#level mugpath_first
{
	masterlevel	float	20
	xp_levels	float	.08
	xp_battles	float	1
	monster_1	string	"Pipe Mimic; 3"
}

// PRE_LIMBUS or PRE_DETTA

#level mugpath_second
{
	masterlevel	float	28
	xp_levels	float	.08
	xp_battles	float	1
	monster_1	string	"Pipe Mimic; 3"
}


#level slounge
{
	masterlevel	float	20
	xp_levels	float	.15
	xp_battles	float	0
	quest_1		string	"Return with TDD"
}

#level hephtower1
{
	masterlevel	float	20
	xp_levels	float	.25
	xp_battles	float	0
	quest_1		string	"Find 3 Keys"
}

#level hephlava
{
	masterlevel	float	20
	xp_levels	float	.25
	xp_battles	float	0
	quest_1		string	"Get Fluid"
}

//======LEVANT MULTIPLE CONFIGURATIONS=============================================

// initial configuration

#level levant1_first
{
	masterlevel	float	21
	xp_levels	float	.25
	xp_battles	float	1
	monster_1	string	"Fire Salamander; 3"
	monster_2	string	"Lava Frog; 1"
}

// PRE_LIMBUS || PRE_DETTA

#level levant1_second
{
	masterlevel	float	30
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Fire Salamander; 3"
	monster_2	string	"Lava Frog; 4"
	monster_3	string	"Stalac Titan; 1"
}

// initial configuration

#level levant2_first
{
	masterlevel	float	21.25
	xp_levels	float	1.75
	xp_battles	float	1
	monster_1	string	"Fire Salamander; 2"
	monster_2	string	"Lava Frog; 3"
	monster_3	string	"Stalac Titan; 1"
	monster_4	string	"Fire Crawler; 4"
}

// PRE_LIMBUS || PRE_DETTA

#level levant2_second
{
	masterlevel	float	30.5
	xp_levels	float	1.5
	xp_battles	float	1
	monster_1	string	"Fire Salamander; 2"
	monster_2	string	"Lava Frog; 7"
	monster_3	string	"Stalac Titan; 1"
	monster_4	string	"Fire Crawler; 4"
}

// initial configuration

#level levant_first
{
	masterlevel	float	23
	xp_levels	float	2
	xp_battles	float	1
	monster_1	string	"Fire Crawler; 2"
	monster_2	string	"Fire Salamander; 3"
	monster_3	string	"Golem; 3"
	monster_4	string	"Magmatos; 1"
	monster_5	string	"HexcephalusMinions; 5"
}

// PRE_LIMBUS || PRE_DETTA

#level levant_second
{
	masterlevel	float	32
	xp_levels	float	.75
	xp_battles	float	1
	monster_1	string	"Fire Crawler; 2"
	monster_2	string	"Fire Salamander; 3"
	monster_3	string	"Golem; 3"
}

//==================================================================================================


#level kraptonmaze
{
	masterlevel	float	25
	xp_levels	float	3
	xp_battles	float	1
	monster_1	string	"El Pinto; 7"
	monster_2	string	"Devil Slug; 5"
	monster_3	string	"Bad Person; 8"
	monster_4	string	"Orange Roughy; 7"
	monster_5	string	"Krapotron Brutalbot; 6"
}

#level krapton
{
	masterlevel	float	28
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"El Pinto; 1"
	monster_2	string	"Krapotron Brutalbot; 3"
	monster_3	string	"Rictus; 1"
}

#level whitendon
{
	masterlevel	float	29
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Record Crime Scene"
	quest_2		string	"Record Fence Opening"
	quest_3		string	"Record Anything Unusual"
}

// Begin PACO segment

#level commiteon
{
	masterlevel	float	29
	xp_levels	float	.25
	xp_battles	float	0
	quest_1		string	"Get Out of Base Camp"
}

#level commhills
{
	masterlevel	float	29.25
	xp_levels	float	1.25
	xp_battles	float	1
	monster_1	string	"Sandmite; 9"
	monster_2	string	"Veneno; 11"
}

#level commbase
{
	masterlevel	float	30.5
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Save Little Girl"
}

// End PACO segment

// Begin PAL segment

#level ballotine
{
	masterlevel	float	29
	xp_levels	float	1
	xp_battles	float	0
	quest_1		string	"Shutoff in Pool 3"
}

#level balltownr
{
	masterlevel	float	30
	xp_levels	float	1
	xp_battles	float	0
	quest_1		string	"Shutoff Complete"
}

// End PAL segment

// Begin RHO segment

#level tensil
{
	masterlevel	float	29
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Rho Find Leaves"
}

#level temple
{
	masterlevel	float	29.5
	xp_levels	float	1.5
	xp_battles	float	0
	quest_1		string	"Enter the Temple"
}

// End RHO segment

// Begin STILETTO segment

#level doren
{
	masterlevel	float	29
	xp_levels	float	.1
	xp_battles	float	0
	quest_1		string	"Doren Beats Me"
}

#level waukees
{
	masterlevel	float	29.1
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Waugee; 6"
	monster_2	string	"Wasp; 5"
}

#level greattree
{
	masterlevel	float	30.1
	xp_levels	float	.9
	xp_battles	float	1
	monster_1	string	"QueenWaugee; 1"
	monster_2	string	"WaugeeMinion; 3"
}

// End STILETTO segment

#level whitecaves-a
{
	masterlevel	float	29.5
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Snow Snake; 3"
	monster_2	string	"Snow Sucker; 5"
}

#level whitecaves-b
{
	masterlevel	float	30
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Snow Snake; 2"
	monster_2	string	"Snow Sucker; 2"
	monster_3	string	"Grumpy Bunny; 3"
	monster_4	string	"Wimpa; 1"
}

// End BOOTS segment

// Note to self:  clamp other party members to level 30 at this point.

#level crevicelanding_first
{
	masterlevel	float	30
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Wall Clam; 12"
}

// limbus_battle_started

#level crevicelanding_second
{
	masterlevel	float	32
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Korethorian Knight; 4"
	monster_2	string	"Korethorian Sergeant; 2"
}


#level crevice_first
{
	masterlevel	float	30.5
	xp_levels	float	1.5
	xp_battles	float	1
	monster_1	string	"Wall Clam; 4"
	monster_2	string	"Crevice Slug; 2"
	monster_3	string	"Killer Hyrax; 6"
	monster_4	string	"BlueSagenKra; 1"
	monster_5	string	"CyanSagenKra; 1"
	monster_6	string	"GreenSagenKra; 1"
	monster_7	string	"MagentaSagenKra; 1"
	monster_8	string	"RedSagenKra; 1"
	monster_9	string	"YellowSagenKra; 1"
}

// load for each of the three limbus battles?  I need to test...

//enter the mega-hack.  Need separate xp configurations for EACH of the three possible numbers of Korethorian Sergeants,
// Xp_configuration for biggun, extra xp_config for crevice, etc.

// Big Gun

#level big_gun
{
	masterlevel	float	32
	xp_levels	float	.5
	xp_battles	float	0
	quest_1		string	"Big Gun"
}



// battle of the bridge; (Battle_Bridge == 1)

#level crevice_second
{
	masterlevel	float	32
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Korethorian Knight; 2"
	monster_2	string	"Korethorian Sergeant; 1"
}


// battle of the cliff, only one sergeant

#level cliff_first
{
	masterlevel	float	32
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Korethorian Sergeant; 1"
}

// battle of the cliff, two sergeants

#level cliff_second
{
	masterlevel	float	32
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Korethorian Sergeant; 2"
}

// battle of the cliff, two sergeants

#level cliff_third
{
	masterlevel	float	32
	xp_levels	float	.5
	xp_battles	float	1
	monster_1	string	"Korethorian Sergeant; 3"
}

//---------------------------------FINAL FUN-------------------------------------------------------------

#level onegate
{
	masterlevel	float	33
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"GEAS Nox Guard; 4"
	monster_2	string	"PAX Guard; 4"
}

#level fortressgrounds
{
	masterlevel	float	34
	xp_levels	float	.05
	xp_battles	float	1
	monster_1	string	"Robottack; 2"
}

// This covers xp for ALL of "fortress"
// the second listing below is just for weapons and mystech balance purposes, and laziness
// and not sleeping, and invisible mind control, and nene, and linna, and shinobu, and sasami, and belldandy

#level fortress
{
	masterlevel	float	34
	xp_levels	float	3
	xp_battles	float	1
	monster_1	string	"Detta Goon; 6"
	monster_2	string	"Detta Goon 1; 2"
	monster_3	string	"Detta Goon 2; 2"
	monster_4	string	"Detta Goon 3; 2"
	monster_5	string	"Head Detta Goon; 3"
	monster_6	string	"Detta Suit Left Leg; 1"
	monster_7	string	"Detta Suit Right Leg; 1"
	monster_8	string	"Detta; 1"
	monster_9	string	"Robottack; 2"
}


#level cineend
{
	masterlevel	float	36
	xp_levels	float	1
	xp_battles	float	1
	monster_1	string	"Poison; 1"
	monster_2	string	"Burn; 1"
	monster_3	string	"Nuts; 1"
	monster_4	string	"Freeze; 1"
	monster_5	string	"Winky; 1"
	monster_6	string	"Slow; 1"
}

// For temp testing

#level fortress2
{
	masterlevel	float	40
	xp_levels	float	2
	xp_battles	float	0
}

//---hack levels-----------------------------------------------------------------

#level ultimate
{
	masterlevel	float	50
	xp_levels	float	2
	xp_battles	float	0
}

#level supergod
{
	masterlevel	float	60
	xp_levels	float	2
	xp_battles	float	0
}

#level hekatomb
{
	masterlevel	float	65
	xp_levels	float	1
	xp_battles	float	0
}